unit CGIXML1;

{
  Demonstrate generating XML from a CGI program.
  Requires 'movie-watcher' alias to be set up in BDE.

  Copyright  Keith Wood (kbwood@iprimus.com.au)
  Written 4 August, 1999.
  Updated 12 December, 2002.
}

interface

uses
  SysUtils, Classes,
{$IFDEF D6UP}
  HTTPProd,
{$ELSE}
  HTTPApp,
{$ENDIF}
  Db, DBTables, HTTPProd;

type
  TwmdXML = class(TWebModule)
    tblMovie: TTable;
      tblMovieMovie_id: TAutoIncField;
      tblMovieName: TStringField;
      tblMovieRating: TStringField;
      tblMovieLength_Mins: TIntegerField;
      tblMovieDirector: TStringField;
      tblMovieSynopsis: TMemoField;
      tblMovieURL: TStringField;
      tblMovieLogo_URL: TStringField;
    tblCinema: TTable;
      tblCinemaCinema_id: TAutoIncField;
      tblCinemaName: TStringField;
      tblCinemaPhone: TStringField;
      tblCinemaAddress: TStringField;
      tblCinemaDirections: TMemoField;
      tblCinemaCandy_bar: TBooleanField;
      tblCinemaDisabled_access: TBooleanField;
    tblScreening: TTable;
      tblScreeningMovie_id: TIntegerField;
      tblScreeningCinema_id: TIntegerField;
      tblScreeningStart_date: TDateField;
      tblScreeningEnd_date: TDateField;
      tblScreeningDigital_sound: TStringField;
      tblScreeningNo_passes: TBooleanField;
    dsrMovie: TDataSource;
    dsrCinema: TDataSource;
    dsrScreening: TDataSource;
    tblStars: TTable;
      tblStarsStar_id: TAutoIncField;
      tblStarsMovie_id: TIntegerField;
      tblStarsStar: TStringField;
    tblPricing: TTable;
      tblPricingPricing_id: TAutoIncField;
      tblPricingCinema_id: TIntegerField;
      tblPricingName: TStringField;
      tblPricingPeriod: TStringField;
      tblPricingAdult: TFloatField;
      tblPricingChild: TFloatField;
      tblPricingDiscount: TFloatField;
    tblSessions: TTable;
      tblSessionsMovie_id: TIntegerField;
      tblSessionsCinema_id: TIntegerField;
      tblSessionsTime: TTimeField;
      tblSessionsPricing_id: TIntegerField;
    pgpMovieWatcher: TPageProducer;
    pgpMovie: TPageProducer;
    pgpCinema: TPageProducer;
    pgpScreening: TPageProducer;
    pgpStars: TPageProducer;
    pgpPricing: TPageProducer;
    pgpSessions: TPageProducer;
    procedure wmdXMLwacXMLAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure pgpMovieWatcherHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: string; TagParams: TStrings; var ReplaceText: string);
    procedure pgpMovieHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: string; TagParams: TStrings; var ReplaceText: string);
    procedure pgpStarsHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: string; TagParams: TStrings; var ReplaceText: string);
    procedure pgpCinemaHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: string; TagParams: TStrings; var ReplaceText: string);
    procedure pgpPricingHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: string; TagParams: TStrings; var ReplaceText: string);
    procedure pgpScreeningHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: string; TagParams: TStrings; var ReplaceText: string);
    procedure pgpSessionsHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: string; TagParams: TStrings; var ReplaceText: string);
    procedure AttributeGetText(Sender: TField; var Text: string;
      DisplayText: Boolean);
    procedure EmptyFieldGetText(Sender: TField; var Text: string;
      DisplayText: Boolean);
    procedure MemoGetText(Sender: TField; var Text: string;
      DisplayText: Boolean);
  private
    function ModifyName(Name: string): string;
    function GetRecords(Table: TTable; Page: TPageProducer): string;
  public
  end;

var
  wmdXML: TwmdXML;

implementation

{$R *.DFM}

{ Main response }
procedure TwmdXML.wmdXMLwacXMLAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  Response.ContentType := 'text/xml';
  Response.Content     := pgpMovieWatcher.Content;
  Handled              := True;
end;

{ Convert field names to XML names }
function TwmdXML.ModifyName(Name: string): string;
begin
  Result := LowerCase(StringReplace(Name, '_', '-', [rfReplaceAll]));
end;

{ Cycle through all the records in the table and generate the XML snippet }
function TwmdXML.GetRecords(Table: TTable; Page: TPageProducer): string;
begin
  Result := '';
  with Table do
  begin
    First;
    while not EOF do
    begin
      Result := Result + Page.Content;
      Next;
    end;
  end;
end;

{ Generate movie-watcher XML document }
procedure TwmdXML.pgpMovieWatcherHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: string; TagParams: TStrings; var ReplaceText: string);
begin
  if TagString = 'movies' then
    ReplaceText := GetRecords(tblMovie, pgpMovie)
  else if TagString = 'cinemas' then
    ReplaceText := GetRecords(tblCinema, pgpCinema)
  else if TagString = 'screenings' then
    ReplaceText := GetRecords(tblScreening, pgpScreening);
end;

{ Add details for a movie }
procedure TwmdXML.pgpMovieHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: string; TagParams: TStrings; var ReplaceText: string);
begin
  if TagString = 'stars' then
    ReplaceText := GetRecords(tblStars, pgpStars)
  else
    ReplaceText := tblMovie.FieldByName(TagString).DisplayText;
end;

{ Add details for a movie star }
procedure TwmdXML.pgpStarsHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: string; TagParams: TStrings; var ReplaceText: string);
begin
  ReplaceText := tblStars.FieldByName(TagString).DisplayText;
end;

{ Add details for a cinema }
procedure TwmdXML.pgpCinemaHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: string; TagParams: TStrings; var ReplaceText: string);
begin
  if TagString = 'pricing' then
    ReplaceText := GetRecords(tblPricing, pgpPricing)
  else
    ReplaceText := tblCinema.FieldByName(TagString).DisplayText;
end;

{ Add details for a cinema pricing scheme }
procedure TwmdXML.pgpPricingHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: string; TagParams: TStrings; var ReplaceText: string);
begin
  ReplaceText := tblPricing.FieldByName(TagString).DisplayText;
end;

{ Add details for a film screening }
procedure TwmdXML.pgpScreeningHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: string; TagParams: TStrings; var ReplaceText: string);
begin
  if TagString = 'sessions' then
    ReplaceText := GetRecords(tblSessions, pgpSessions)
  else
    ReplaceText := tblScreening.FieldByName(TagString).DisplayText;
end;

{ Add details for a session }
procedure TwmdXML.pgpSessionsHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: string; TagParams: TStrings; var ReplaceText: string);
begin
  ReplaceText := tblSessions.FieldByName(TagString).DisplayText;
end;

{ Include attributes only if present }
procedure TwmdXML.AttributeGetText(Sender: TField; var Text: string;
  DisplayText: Boolean);
begin
  if Sender.AsString <> '' then
    Text := ' ' + ModifyName(Sender.FieldName) + '="' + Sender.AsString + '"';
end;

{ Include empty field tag only if flag in DB set }
procedure TwmdXML.EmptyFieldGetText(Sender: TField;
  var Text: string; DisplayText: Boolean);
begin
  if Sender.AsBoolean then
    Text := '<' + ModifyName(Sender.FieldName) + '/>';
end;

{ Display longer text }
procedure TwmdXML.MemoGetText(Sender: TField; var Text: string;
  DisplayText: Boolean);
begin
  Text := Sender.AsString;
end;

end.
